//==========================================
// Misc string helper functions
//==========================================

//-----------------------------------
// Returns a SS-BB-SH-D string from a table row.
String generateLocString(TableRow pRow) {
  return(pRow.getString("Stack")
    + "-" +  pRow.getString("Bank")
    + "-" +  pRow.getString("Shelf")
    + "-" +  pRow.getString("Depth"));
}

//-----------------------------------
// Replaces HTML reserved characters ("&" -> "&amp;" etc.)
String replaceHTMLReservedCharacters(String s) {
  s = s.replaceAll("&", "&amp;");
  return(s);
}

//-----------------------------------
// Replaces ^ with , to deal with CSV issue
String replaceCommaCharacter(String s) {
  s = s.replace("^", ", ");
  return(s);
}

//-----------------------------------
// JSON - Returns (3 * i) spaces, for human readability
String ind(int numIndents) {
  String indentString = "";
  for (int i=0; i<numIndents; i++) {
    indentString += ("  ");
  }
  return(indentString);
}

//-----------------------------------
// Creates a JSON key / value pair.
// Pass: key, value, comma T/F, return T/F
String JSONPair(String k, String v, boolean addComma, boolean addReturn) {
  if (addComma) {
    if (addReturn) {
      return(quote(k) + ":" + quote(v) + "," + "\n");
    } else {
      return(quote(k) + ":" + quote(v) + ",");
    }
  } else {
    return(quote(k) + ":" + quote(v));
  }
}

//----------------------------------
// JSON - Returns a string placed inside quotes.
String quote(String s) {
  return("\"" + s + "\"");
}