/*==========================================
 Builds and exports the JSON for Shelves info
 Note: JSON var names have been condensed to 2-letter strings.
 See comments for readable names.
 ==========================================*/

void makeShelfJSON(EntryClass[] fullTopics) {

  // ArrayList for building the JSON
  ArrayList<String> stringList = new ArrayList<String>();

  // Open var array
  stringList.add("var stackData = [");

  // Step through table rows
  for (TableRow outerRow : table.rows()) {
    // Open individual shelf JSON 
    stringList.add("{");

    // Creates a location string and adds it to the JSON
    // name: LOCATION
    String locString = generateLocString(outerRow);
    stringList.add(ind(1) + JSONPair("Lc", locString, true, false));

    // Open tag for entry JSON array
    // name: ENTRIES
    stringList.add(ind(1) + "\"Es\": [");

    // Creates an array with topics and titles.
    String shelfTopicsAndTitles = outerRow.getString("Stack Topics") + ", " + outerRow.getString("Titles");
    String[] shelfEntryTopics = shelfTopicsAndTitles.split(", ");
    shelfEntryTopics = sort(shelfEntryTopics);

    // Loops through topics array
    for (int i=0; i<shelfEntryTopics.length; i++) {

      // replaces HTML reserved chars
      shelfEntryTopics[i] = replaceHTMLReservedCharacters(shelfEntryTopics[i]);
      // replaces ^ with ,
      shelfEntryTopics[i] = replaceCommaCharacter(shelfEntryTopics[i]);

      // Create Topic JSON
      stringList.add(ind(2) + "{");
      stringList.add(ind(2) + JSONPair("Tp", shelfEntryTopics[i], true, false));

      //Loop full entry list to get topic's Archive and Title booleans
      boolean currentArchiveLink = false;
      for (int q=0; q<fullTopics.length; q++) {
        if (fullTopics[q].Topic.equals(shelfEntryTopics[i])) {

          // Archive boolean
          if (fullTopics[q].archiveResults) {
            stringList.add(ind(2) + "\"Ar\":" + 1 +",");
          }

          // Title boolean
          if (fullTopics[q].title) {
            stringList.add(ind(2) + "\"Ti\":" + 1 +",");
          }
        }
      }

      // name: TOPIC LOCATIONS
      stringList.add(ind(2) + "\"Tl\": [");

      // loops through full topics EntryClass array
      for (int j=0; j<fullTopics.length; j++) {

        // When a matching topic is found
        if (shelfEntryTopics[i].equals(fullTopics[j].Topic)) {

          // step through Locations ArrayList in fullTopics
          for (int k=0; k<fullTopics[j].Locations.size(); k++) {

            // add found fullEntryTopics locations to the JSON
            String innerLocString = fullTopics[j].Locations.get(k);
            stringList.add(ind(3) +  "\"" + innerLocString + "\",");
          }
        }
      }
      //kill final comma and close TopicLocations
      String commaCut = stringList.get(stringList.size()-1);
      stringList.remove(stringList.size()-1);

      // Close TopicLoc array
      stringList.add(commaCut.substring(0, commaCut.length()-1) + "]");

      //close entry
      stringList.add(ind(2) + "},");
    }

    //replace last Entry "}," with "}" and close Entry array with ]
    stringList.remove(stringList.size()-1);
    stringList.add(ind(2) + "}]");

    //close outerRow
    stringList.add("},");
  }

  //replace "}," with "}" and close final var array with ]
  stringList.remove(stringList.size()-1);
  stringList.add(ind(1) + "}");
  stringList.add("]");

  String [] stringListConvert = stringList.toArray(new String[stringList.size()]);
  saveStrings("shelves-JSON.js", stringListConvert);
}