import java.util.Arrays;

void makeListHTML(EntryClass[] fullTopics) {
  ArrayList<String> ListHTML = new ArrayList<String>();
  int cStack = 0;

  ListHTML.add("<table>");
  ListHTML.add("<tr>" +
    "<th>STK</th>" + 
    "<th>BNK</th>" + 
    "<th>SHF</th>" + 
    "<th>DT</th>" + 
    "<th>Photo</th>" + 
    "<th>Category</th>" + 
    "<th>Topics</th>" + 
    "<th>Titles</th>" + 
    "</tr>");

  for (TableRow row : table.rows()) {

    if (Integer.parseInt(row.getString("Shelf")) == 1) {
      if (cStack != Integer.parseInt(row.getString("Stack"))) {
        // Time for a new stack
        cStack++;
        ListHTML.add("<tr class=\"ns\" id=\"stack-" + cStack + "\">");
      } else {
        ListHTML.add("<tr class=\"nr\">");
      }
    } else {
      ListHTML.add("<tr>");
    }

    ListHTML.add(makeHTMLCell(row.getString("Stack")));
    ListHTML.add(makeHTMLCell(row.getString("Bank")));
    ListHTML.add(makeHTMLCell(row.getString("Shelf")));
    ListHTML.add(makeHTMLCell(row.getString("Depth")));

    if (row.getString("Row File A").length() > 2) {
      ListHTML.add(makeHTMLCellPhotoLink(row.getString("Row File A")));
    } else {
      ListHTML.add(makeHTMLCell(""));
    }

    ListHTML.add(makeHTMLCell(row.getString("Topic Categories")));
    
    String azString = alphabetize(row.getString("Stack Topics"), fullTopics);
    ListHTML.add(makeHTMLCell(azString));

    azString = alphabetize(row.getString("Titles"), fullTopics);
    ListHTML.add(makeHTMLCell(azString));

    ListHTML.add("</tr>");
  }
  ListHTML.add("</table>");

  String[] ListArray = ListHTML.toArray(new String[ListHTML.size()]);
  saveStrings("list.html", ListArray);
}

String makeHTMLCell(String s) {
  return("<td>" + s + "</td>");
}

String makeHTMLCellPhotoLink(String s) {
  String cut = s.split(".jpg")[0] + "-HALF.jpg";
  // &#8209;
  //return("<td><a href=\"Zoom/" + cut + "\">"+ s.replaceAll("-", "&#8209;") + "</a></td>");
  return("<td><a href=\"Zoom/" + cut + "\">LINK</a></td>");
}

String makeHTMLCellCommaLine(String s) {
  return("<td>" + s.replaceAll(", ", ",<br>") + "</td>");
}


//---------
String alphabetize(String s, EntryClass[] fT) {
  String[] sArray = s.split(", ");
  Arrays.sort(sArray);

  for (int i=0; i<sArray.length; i++) {
    for (int j=0; j<fT.length; j++) {
      if (sArray[i].equals(fT[j].Topic)) {
        if (fT[j].archiveResults) {
          String searchString = sArray[i].replaceAll(" ", "+");
          searchString = "https://archive.org/details/prelinger_library?and%5B%5D=" + searchString;
          searchString += "&sin=";
          
          sArray[i] = "<a href=\""+searchString+"\">" + sArray[i] + "</a>";
          //sArray[i] = "<a class=\"sa\" href=\"#\">" + sArray[i] + "</a>";
        }
      }
    }
  }

  String returnString = "";

  for (int i=0; i<sArray.length; i++) {
    returnString += replaceCommaCharacter(sArray[i]);
    if (i != (sArray.length - 1)) {
      returnString += "<br>";
    }
  }

  return(returnString);
}