//==========================================
// Creates the full alphabetical HTML
//==========================================
void makeAlphaSidebarHTML(EntryClass[] fullTopics) {
  // ArrayList for all the HTML strings
  ArrayList<String> AZList = new ArrayList<String>();

  // Open HTML
  AZList.add("<html>");
  AZList.add("");

  // Steps through the full topics array
  for (int i=0; i<fullTopics.length; i++) {

    // creates an ArrayList w/ HTML for the current entry
    ArrayList<String> singleHTMLList = makeSingleEntryHTML(fullTopics[i]);

    // And adds it to the main ArrayList
    AZList.addAll(singleHTMLList);
  }

  // Close HTML
  AZList.add("</html>");

  String[] AZArray = AZList.toArray(new String[AZList.size()]);
  saveStrings("sidebar-alpha.HTML", AZArray);
}


//==========================================
// Makes an ArrayList with the HTML string for a single entry
//==========================================
ArrayList<String> makeSingleEntryHTML(EntryClass cEntry) {

  // String list for everything
  ArrayList<String> cHTMLList = new ArrayList<String>();

  // entry class
  cHTMLList.add("<div class=\"se\">");

  // h3 Title topic
  cHTMLList.add("<h3 class=\"st\">");
  cHTMLList.add("<span class=\"si\">▸</span>");

  // T/F for italic title formatting
  if (cEntry.title == false) {
    cHTMLList.add("<a href=\"#\">" + cEntry.Topic + "</a></h3>");
  } else {
    cHTMLList.add("<a class=\"ti\" href=\"#\">" + cEntry.Topic + "</a></h3>");
  }

  // locations list
  cHTMLList.add("<ul>");
  for (int k=0; k<cEntry.Locations.size(); k++) {
    cHTMLList.add("<li><a class=\"ss\" href=\"#\">" + cEntry.Locations.get(k) + "</a></li>");
  }

  // Add archive.org link and close ul ➚   ↗
  if (cEntry.archiveResults) {
    cHTMLList.add("<li><a class=\"sa\" href=\"#\">Archive.org Results</a> ➚</li>");
  }
  cHTMLList.add("</ul>");

  // close entry class
  cHTMLList.add("</div>");
  cHTMLList.add("");

  return(cHTMLList);
}




//==========================================
// NEW
// Makes Stacks + Categories HTML
//==========================================
void makeStackCategoriesSidebarHTML(EntryClass[] fullTopics) {
  int numStacks = 6;

  // List for HTML Strings
  ArrayList<String> HTMLList = new ArrayList<String>();

  // Open HTML
  HTMLList.add("<html>");
  HTMLList.add("");

  // Main loop for each stack
  for (int cStack=1; cStack<(numStacks+1); cStack++) {

    // Stack Heading
    HTMLList.add("<!-- NEW STACK -->");
    //HTMLList.add("<h4>Stack 0" + (cStack+1) + " Categories</h4>");
    HTMLList.add("<h4>Stack 0" + (cStack) + " Categories</h4>");
    HTMLList.add("");

    // Make an ArrayList for all the categories in the stack (in traversal order)
    ArrayList<String> StackCats = new ArrayList<String>();
    for (TableRow row : table.rows()) {
      if (Integer.parseInt(row.getString("Stack")) == cStack) {
        String rowCat = row.getString("Topic Categories");
        if (StackCats.contains(rowCat) == false) {
          StackCats.add(rowCat);
        }
      }
    }

    // Convert to StackCats an array for ease
    String[] StackCatsArray = StackCats.toArray(new String[0]);
    for (int cCat=0; cCat<StackCatsArray.length; cCat++) {

      // For each category, loop through and match locations
      // Add entry from the full list if they match the location
      ArrayList<EntryClass> CatEntries = new ArrayList<EntryClass>();
      for (TableRow row : table.rows()) {

        // 1. If the row has the category
        if ((Integer.parseInt(row.getString("Stack")) == cStack) &&
          (row.getString("Topic Categories").equals(StackCatsArray[cCat]))) {

          // 2. Get the current row location
          String cLoc = generateLocString(row);

          // 3. Loop through the master topics list
          // If the location matches, add it to the CatEntry list.
          for (int i=0; i<fullTopics.length; i++) {
            for (int j=0; j<fullTopics[i].Locations.size(); j++) {
              if (fullTopics[i].Locations.get(j).equals(cLoc)) {
                if (CatEntries.contains(fullTopics[i]) == false) {
                  CatEntries.add(fullTopics[i]);
                }
              }
            }
          }
        }
      }


      //Create Category Heading
      HTMLList.add("<h5>");
      HTMLList.add("<span class=\"si\">▸</span>");
      HTMLList.add("<a href=\"#\">" + StackCatsArray[cCat] + "</a></h5>");

      // create category div
      HTMLList.add("<div class=\"ce\">");
      HTMLList.add("");

      // Convert CatEntries to an array for ease
      EntryClass[] CatEntriesArray = CatEntries.toArray(new EntryClass[0]);
      for (int i=0; i<CatEntriesArray.length; i++) {
        // creates an ArrayList w/ HTML for the current entry
        ArrayList<String> singleHTMLList = makeSingleEntryHTML(CatEntriesArray[i]);
        // And adds it to the main ArrayList
        HTMLList.addAll(singleHTMLList);
      }

      // close category div
      HTMLList.add("");
      HTMLList.add("</div>");
    }

    // End Main Loop
  }

  // Close HTML
  HTMLList.add("</html>");

  String[] AZArray = HTMLList.toArray(new String[HTMLList.size()]);
  saveStrings("sidebar-stacks.HTML", AZArray);
}


//==========================================
// OLD
// This one takes the full A-Z list and divides it up via stacks
//==========================================
void makeStackSidebarHTML(EntryClass[] fullTopics) {
  // This could be hard-coded but let's make it a variable for cleanliness
  int numStacks = 6;
  int numBanks = 12;

  // Nested ArrayLists for holding entries belonging to each stack.
  // See here for Qs about nesting generics: https://stackoverflow.com/a/2992643/9012194
  ArrayList<ArrayList<EntryClass>> stackTopics2DList = new ArrayList<ArrayList<EntryClass>>();
  for (int i=0; i<numStacks; i++) {
    stackTopics2DList.add(new ArrayList<EntryClass>());
  }

  for (int i=0; i<fullTopics.length; i++) {
    for (int j=0; j<fullTopics[i].Stacks.size(); j++) {
      // Stack strings count up from 1 (hence: -1)
      int stackIndex = Integer.parseInt(fullTopics[i].Stacks.get(j)) - 1;
      stackTopics2DList.get(stackIndex).add(fullTopics[i]);
    }
  }

  // List for HTML Strings
  ArrayList<String> AZList = new ArrayList<String>();

  // Open HTML
  AZList.add("<html>");
  AZList.add("");

  // Loop through each List individually
  for (int i=0; i<numStacks; i++) {
    AZList.add("<!-- NEW STACK -->");
    AZList.add("<h4>Stack 0" + (i+1) + " Topics</h4>");
    AZList.add("");

    for (int j=0; j<stackTopics2DList.get(i).size(); j++) {
      // Create the HTML for a single entry and add to the main
      EntryClass cEntry = stackTopics2DList.get(i).get(j);
      ArrayList<String> singleEntryHTMLList = makeSingleEntryHTML(cEntry);
      AZList.addAll(singleEntryHTMLList);
    }
  }

  // Close HTML
  AZList.add("</html>");

  String[] AZArray = AZList.toArray(new String[AZList.size()]);
  saveStrings("sidebar-stacks.HTML", AZArray);
}



//==========================================
// OLD
// This one takes the full A-Z list and divides it up via stacks and banks
//==========================================
void makeStackBankSidebarHTML(EntryClass[] fullTopics) {
  // This could be hard-coded but let's make it a variable for cleanliness
  int numStacks = 6;
  int numBanks = 12;

  // Nested ArrayLists for holding entries belonging to each stack.
  // See here for Qs about nesting generics: https://stackoverflow.com/a/2992643/9012194
  ArrayList<ArrayList<EntryClass>> stackTopics2DList = new ArrayList<ArrayList<EntryClass>>();
  for (int i=0; i<numStacks; i++) {
    stackTopics2DList.add(new ArrayList<EntryClass>());
  }

  for (int i=0; i<fullTopics.length; i++) {
    for (int j=0; j<fullTopics[i].Stacks.size(); j++) {
      // Stack strings count up from 1 (hence: -1)
      int stackIndex = Integer.parseInt(fullTopics[i].Stacks.get(j)) - 1;
      stackTopics2DList.get(stackIndex).add(fullTopics[i]);
    }
  }

  // List for HTML Strings
  ArrayList<String> AZList = new ArrayList<String>();

  // Open HTML
  AZList.add("<html>");
  AZList.add("");

  // Loop through each List individually
  for (int i=0; i<numStacks; i++) {
    AZList.add("<!-- NEW STACK -->");
    AZList.add("<h4>Stack 0" + (i+1) + " Topics</h4>");
    AZList.add("");

    for (int j=0; j<stackTopics2DList.get(i).size(); j++) {
      // Create the HTML for a single entry and add to the main
      EntryClass cEntry = stackTopics2DList.get(i).get(j);
      ArrayList<String> singleEntryHTMLList = makeSingleEntryHTML(cEntry);
      AZList.addAll(singleEntryHTMLList);
    }
  }

  // Close HTML
  AZList.add("</html>");

  String[] AZArray = AZList.toArray(new String[AZList.size()]);
  saveStrings("sidebar-stacks.HTML", AZArray);
}