//==========================================
// A Class for holding Entry info
class EntryClass implements Comparable<EntryClass> {
  String Topic, Category;
  ArrayList<String> Locations;
  ArrayList<String> Stacks;
  boolean archiveResults;
  boolean title;

  // Sorting override
  @Override
    public int compareTo(EntryClass other) {
    if (!this.Topic.equalsIgnoreCase(other.Topic)) {
      return this.Topic.compareTo(other.Topic);
    } else if (!this.Topic.equalsIgnoreCase(other.Topic)) {
      return this.Topic.compareTo(other.Topic);
    } else {
      return(0);
    }
  }

  // Hashcode generation override
  // TK DOUBLE-CHECK THIS HASHCODE FUNCTION WITH A CS PROFESSIONAL
  @Override
    public int hashCode() {
    int h = 11;
    char val[] = this.Topic.toCharArray();
    for (int i=0; i<val.length; i++) {
      h = 31 * h + val[i];
    }
    return h;
  }

  // Equals override
  @Override
    public boolean equals(Object obj) {    
    if (obj == null) return false;
    if (!(obj instanceof EntryClass))
      return false;
    if (obj == this)
      return true;
    EntryClass other = (EntryClass)obj;
    return ((this.Topic.equalsIgnoreCase(other.Topic)) && (this.title == other.title));
  }

  EntryClass(String passTopic) {
    Topic = passTopic;
    Locations = new ArrayList<String>();
    Stacks = new ArrayList<String>();
  }

  EntryClass(boolean passTitle, String passTopic) {
    title = passTitle;
    Topic = passTopic;
    Locations = new ArrayList<String>();
    Stacks = new ArrayList<String>();
  }
}

//===================================================
// Creates the full entries array, passes back to main. 
EntryClass[] makeEntriesArray() {
  // HashSet for entry classes
  HashSet<EntryClass> fullEntryHashSet = new HashSet<EntryClass>();

  // 1 ---------------------------------------------
  // Loops through the rows
  for (TableRow row : table.rows()) {

    // TOPICS
    // Creates an array by splitting at the comma
    // loops through the array, adds topic to HashSet
    String[] rowTopicsArray = (row.getString("Stack Topics")).split(", ");
    if (rowTopicsArray.length > 0) {
      for (int i=0; i<rowTopicsArray.length; i++) {
        // First value in the constructor: is a Title? T/F
        EntryClass cEntry = new EntryClass(false, rowTopicsArray[i]);
        fullEntryHashSet.add(cEntry);
      }
    }

    // TITLES
    // The first check is for false-positives
    // After this, works the same as above
    if (row.getString("Titles").length() > 1) {
      String[] rowTitlesArray = (row.getString("Titles")).split(", ");
      if (rowTitlesArray.length > 0) {
        for (int i=0; i<rowTitlesArray.length; i++) {
          EntryClass cEntry = new EntryClass(true, rowTitlesArray[i]);
          fullEntryHashSet.add(cEntry);
        }
      }
    }
  }

  // 2 -----------------------------------------------------
  // We now have a hash set with all the topics and titles.
  // Loop through the rows once again, adding locations where
  // each entry "Topic" is found to the "Locations" ArrayList.

  // Convert HashSet to array for ease.
  EntryClass[] fullEntryArray = fullEntryHashSet.toArray(new EntryClass[0]);

  // Loop through full enty array
  for (int i=0; i<fullEntryArray.length; i++) {

    // cEntry for convenience
    EntryClass cEntry = fullEntryArray[i];

    // loop through table rows
    for (TableRow row : table.rows()) {
      String[] cArray;

      // cEntry T/F indicates which cell to look at
      if (cEntry.title == false) {
        cArray = (row.getString("Stack Topics")).split(", ");
      } else {
        cArray = (row.getString("Titles")).split(", ");
      }

      // Loop through topic or title array, adding locations and stacks where found
      for (int j=0; j<cArray.length; j++) {
        if (cEntry.Topic.equals(cArray[j])) {
          String locString = generateLocString(row);
          fullEntryArray[i].Locations.add(locString);
          if (!fullEntryArray[i].Stacks.contains(row.getString("Stack"))) {
            fullEntryArray[i].Stacks.add(row.getString("Stack"));
          }
        }
      }
    }
  }

  // 3. ----------------------------------
  // Debug Entry array (if needed)
  
  //saveDebugTextFile(fullEntryArray);
  Arrays.sort(fullEntryArray);
  //saveDebugTextFile(fullEntryArray);

  // 4. ----------------------------------
  // Ping archive.org for search results. 

  // Set to TRUE to generate a new CSV. This will take an-hour-or-so.
  // Set to FALSE to use the CSV (created from a previous run of TRUE function) 

  // *** ARCHIVE RESULTS FLAG
  boolean getOnlineResults = false;

  if (getOnlineResults) {
    // Generate a new Archive.org CSV, and return the values.
    fullEntryArray = makeNewArchiveResultsCSV(fullEntryArray);
  } else {
    // Otherwise, load the existing CSV and parse it.
    String[] archiveResultsCSV = loadStrings("ArchiveOrgResults.csv");
    // Loop through the Archive.org Results CSV
    // Add the CSV's T/F boolean to every entry object
    String archiveBooleanString;
    for (int i=0; i<fullEntryArray.length; i++) {
      println(archiveResultsCSV[i]);
      if (archiveResultsCSV[i].equals("null")) {
        fullEntryArray[i].archiveResults = false;
      } else {
        archiveBooleanString = archiveResultsCSV[i].split(",")[1];
        if (archiveBooleanString.equals("true")) {
          fullEntryArray[i].archiveResults = true;
        } else {
          fullEntryArray[i].archiveResults = false;
        }
      }
    }
  }

  // 5. ------------------------------
  // Replace reserved HTML characters
  for (int i=0; i<fullEntryArray.length; i++) {
    if (fullEntryArray[i].Topic.indexOf("^") != -1) {
      fullEntryArray[i].Topic = replaceCommaCharacter(fullEntryArray[i].Topic);
    }
  }

  // 6. ------------------------------
  // Return the array
  return(fullEntryArray);
}


//======================================================
EntryClass[] makeNewArchiveResultsCSV(EntryClass[] fea) {

  // String array For list export
  String[] resultPairs = new String[fea.length];
  for (int i=0; i<fea.length; i++) {
    // Debug:
    println("-----------------");
    println("Top: " + fea[i].Topic);
    println("Ttl: " + fea[i].title);
    //println("Cat: " + fullTopicsEntries[i].Category);
    println("Loc: " + fea[i].Locations);


    if (archiveSearchStringOK(fea[i].Topic) == false) {
      fea[i].archiveResults = false;
    } else {

      //New addition for replacing ^
      String searchString = fea[i].Topic;
      if (searchString.indexOf("^") != -1) {
        println("  > Replacing ^");
        String splitSearchString = searchString.split("\\^")[0];
        println("  > splitSearchString: " + splitSearchString);
        searchString = splitSearchString;
        println("  > searchString: " + searchString);
      }

      String urlString = "https://archive.org/details/prelinger_library?and%5B%5D=";
      urlString += (searchString).replace(" ", "+");
      urlString += "&sin=";

      // get the HTML from Archive.org
      GetRequest get = new GetRequest(urlString);
      get.send();

      // Split the results and look for "No Results..." string
      String[] htmlSplit = get.getContent().split("\n");

      /*---------------------------------------
       //DEBUG: This prints out the full HTML file.
       //for (int j=0; j<htmlSplit.length; j++) {
       //  println("J: " + j + " | " + htmlSplit[j]);
       //  if (htmlSplit[j].indexOf("No results matched your criteria.") != -1 ) {
       //    archiveResults = false;
       //  }
       //}
       ---------------------------------------*/

      // From the above debug, we know the line we're looking for is around here:
      int archiveHTMLIndex = 783;

      // Loop through the HTML strings looking for the results. 
      boolean archiveResults = true;
      for (int j=archiveHTMLIndex-100; j<htmlSplit.length; j++) {
        if (htmlSplit[j].indexOf("<!--/.results-->") != -1) {
          archiveHTMLIndex = j;
          break;
        }
      }

      // If you see the magic words, no results were returned.
      if (htmlSplit[archiveHTMLIndex].indexOf("No results matched your criteria.") != -1) {
        archiveResults = false;
      }

      // Set the entry object
      fea[i].archiveResults = archiveResults;

      // Sets the string for output
      String resultString = fea[i].Topic + "," + fea[i].archiveResults;
      resultPairs[i] = resultString;
      println("RESULT: "  + fea[i].archiveResults);
    }
  }

  saveStrings("ArchiveOrgResults-12.csv", resultPairs);
  return(fea);
}


//======================================================
boolean archiveSearchStringOK(String s) {
  // returns F if the string has problematic chars.
  boolean searchOK = ((s.indexOf("[") == -1) &&
    (s.indexOf("]") == -1) &&
    (s.indexOf("(") == -1) &&
    (s.indexOf(")") == -1) &&
    (s.indexOf("\"") == -1) &&
    (s.indexOf("\"") == -1) &&
    (s.indexOf("!") == -1));
  return(searchOK);
}



//======================================================
void saveDebugTextFile(EntryClass[] fea) {
  String[] checkStringArray = new String[fea.length];
  for (int i=0; i<fea.length; i++) {
    String checkString = (i +": " + "\n" 
      + "   " + fea[i].Topic + "\n" 
      + "   " + fea[i].title + "\n"
      + "   " + fea[i].Stacks + "\n"
      + "   " + fea[i].Locations + "\n");
    checkStringArray[i] = checkString;
  }
  saveStrings("CheckStrings-" + millis() + ".txt", checkStringArray);
}